
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;


/**
 * Classe abstrata que representa um objeto do jogo.
 * Possui posio x,y onde est na tela; Uma velocidade
 * horizontal e vertical; Um conjunto de imagens que
 * representam graficamente o objetoe mtodos para 
 * deteco de coliso e propriedades do objeto
 */
public abstract class GameObject extends Sprite {

    /** Velocidade horizontal */
    private int xspeed;

    /** Velocidade vertical */
    private int yspeed;
    
    /**
     * Construtor
     *
     * @param x Posio horizontal
     * @param y Posio vertical
     * @param image Imagem que representa o objeto
     * @param frameWidth Largura do frame do sprite
     * @param frameHeight Altura do frame do sprite
     * @param initialFrameSequence Frame sequence inicial
     */
    public GameObject(int x, int y, Image image, int frameWidth, int frameHeight, 
    		int[] initialFrameSequence) {
    	super(image, frameWidth, frameHeight);
    	this.setPosition(x, y);
    	this.setFrameSequence(initialFrameSequence);
    }

    /**
     * Deve ser implementado pela sub classe
     */
    public abstract void update();
    
    /**
     * Permite que uma sub classe aplique a velocidade 
     * mudando a posio do objeto. 
     */
    protected void applySpeed() {
    	this.move(this.xspeed, this.yspeed);
    }

    /**
     * Verifca a interseo entre dois Sprites
     *
     * @param GameItem The game item to be tested.
     */
    public boolean intersects(GameObject item) {
    	// Checar coliso apenas com bounding-box, sem pixel level
        return this.collidesWith(item, false);
    }    

    /* ************************************************************/
    /* Mtodos get() e set()
    /* ************************************************************/

    public int getXspeed() {
        return xspeed;
    }

    public void setXspeed(int newXspeed) {
        this.xspeed = newXspeed;
    }

    public int getYspeed() {
        return yspeed;
    }

    public void setYspeed(int newYspeed) {
        this.yspeed = newYspeed;
    }

}
